NB. Arithmetic mean
w=. 2.3 5 3.5 6
am=. +/ % #
sum=. +/
tally=. #
am1=. sum % tally
a=. i. 3 4

NB. Geometric and harmonic means
gm=. # %: */
hm=. % @ am @ %
means=. am,gm,hm
gm1=. ^ @ am @ ^.

NB. Variance and standard deviation
dev=. - am
ss=. +/ @ *: @ dev
var=. ss % <:@#
sd=. %: @ var

NB. Valence
mod7=. 7&|
cube=. ^&3
even=. 0: = 2&|

NB. Covariance and correlation I
x1=. 12 18 24 30 36 42 48
y1=. 5.27 5.68 6.25 7.21 8.02 8.71 8.42
sp=. +/ @ (*&dev)
cov=. sp % <:@#@]
cor=. cov % (*&sd)


NB. Median and quartiles
u=. 22 14 32 30 19 16 28 21 25 31
sort=. /:~
midindices=. (<. , >.) @ -: @ <: @ #
midvalues=. midindices { ]
q2=. am @ midvalues
q1=. q2 @ ((q2 > ]) # ])
q3=. q2 @ ((q2 < ]) # ])
Q1=. q1 @ sort
median=. Q2=. q2 @ sort
Q3=. q3 @ sort
five=. ({.,q1,q2,q3,{:) @ sort

NB. Discrete frequency distributions
over=. ({.,.@;}.)@":@,
by=. ' '&;@,.@[,.]
a=. 1 1 0 3 1 3 1
fr=. +/"1 @ =   NB. fr=. #/.~
sfr=. fr @ sort
rfr=. +/"1 @ (=/)
mfr=. (i.@>:@(>./)) rfr ]      
frtab=. ~. ,. fr
sfrtab=. frtab @ sort
rfrtab=. [ ,. rfr
mfrtab=. (i.@>:@(>./)) ,. mfr
d=. 1 5 2 4 6 5 1 6 2 5
DieFr=. 1 2 3 4 5 6&rfr
alpha=. 'abcdefghijklmnopqrstuvwxyz'
afr=. [: +/"1 alpha&(=/)
afrtab=. [: alpha&(;"0) afr
afrnubtab=. (([: 0&~: >@{:"1) # ]) @ afrtab 
safrnubtab=.(([:\:[:>({:"1)@]) { ])@afrnubtab

NB. Mode
z=. 4 6 2 1 3 6 0
mode=. (([:imax{:"1){{."1) @ frtab
imax=. (]e.>./)#i.@#@]

NB. Continuous frequency distributions
b=. 5.2 8.6 3.4 8.1 9.2 5.3 4.1 8.2 9.9 4.8
cfrpts=. -:@(1&{) + {. + 1&{ * i.@{:
cfr=. i.@{:@[ rfr [: <. (] - {.@[) % 1&{@[
cfrtab=. cfrpts@[ ,. cfr

NB. Box and open
hm1=. am &. % 
gm2=. am &. ^.

NB. Discrete frequency tables
y=. 0 1; 1 1; 1 2; 0 1; 0 0; 1 2; 0 0; 1 0; 0 1
RFR=. [: +/"1 ({@[) =/ ]
rfr1=. <"1 @ [ RFR {@ (<"1 @ ]) 
tsum=. +/ @ ,
TableData=. 3 4 $ 18 29 70 115 17 28 30 41 11 10 11 20
ExpFrTab=. (+/"1 */ +/)  % tsum
ChiSqTab=. [: tsum ([: *: ] - ExpFrTab) % ExpFrTab
Table22Data=. (2 2&$ &. >) (5 2 3 3); ( 6 1 2 4); 7 0 1 5
pr22=. (*/ @ !@(+/"1 , +/)) % */ @ (! @ (, , tsum))   

NB. Barcharts
bars=. #&'*' &. >
barchart=. ] ;"1 0 bars @ ({:"1) @ ]

NB. Stem and leaf diagrams
U=. 14 16 19 21 22 25 28 30 31 32
div=. <. @ %
classify=. (div&10 </. ])
stem=. {. @ (10&* @ div&10)
leaves=. 10&|
SL=. stem ; leaves
SLlist=. (SL &. >) @ classify 
SLtable=. ;"0 @ SLlist @ sort

NB. Explicit definition I
AM=. 3 : 0
(+/ % #) y.
:
(+/x.*y.) % +/x.
)

AM1=. 3 : 0
((# $ 1:) y.)  AM y.
:
(+/x.*y.) % +/x.
)

table=. 1 : 0
[ by ] over x./
)

NB. Summary statistics
x=. 5.2 3.1 2.9 4.5
summary=. 3 : 0
r=.  'Sample size      ',5.0 ": #y.
z=. five y.
r=. r,: 'Minimum           ', 8.3 ": {. z
r=. r, 'Maximum           ',8.3": {: z
r=. r, 'Arithmetic mean   ',8.3": am y.
r=. r, 'Variance          ',8.3": var y.
r=. r, 'First quartile    ',8.3": 1{ z
r=. r, 'Median            ',8.3":2{ z
r=. r, 'Third quartile    ',8.3":3{ z
r=. r, 'Standard deviation',8.3": sd y.
r=. r, 'Geometric mean    ',8.3": gm y.
r=. r, 'Harmonic mean     ',8.3": hm y. 
) 

NB. Verb rank
jrank=. 1 : 0
x. b. 0
)

NB. Linear regression
mp=. +/ . *
sr=. 3 : 0
:
('b0';'b1')=. b=. y.%.X=.1,"0 x.
yest=: b0+b1*x.
sst=. +/*:y.-am y.
sse=. +/*:y.- X +/ . * b
mse=. sse%<:<:$y.
seb=. %:mse%+/*:x.-am x.
rsq=. 1-sse%sst
fmt=. 10.5&":
r=. 'Slope       ',fmt b1
r=. r,: ' S.E.       ',fmt seb
r=. r,'Intercept   ',fmt b0
r=. r,'S.E. of est.',fmt %:mse
r=. r,'Corr. sq.   ',fmt rsq  
)

NB. Base and antibase
tt=. #: @ i. @ (2&^)
ott=. (/: +/"1) @ tt 
ptt=. (+/"1 @ tt@] e. [) # tt@]
indices=. <"1 @ (, #: i.)

NB. Covariance and correlation II
d=. 1 4 2 2 1 3;0 6 4 3 1 5;10 17 13 14 12 15
pairs=. (>@indices @ (2: $ $@])) {"1 1 ]
covtable=. (({.@]) cov ({:@]))"2 @ (>@pairs)
cortable=. (({.@]) cor ({:@]))"2 @ (>@pairs)
ctable=. 1 : 0
(({.@]) x. ({:@]))"2 @ (>@pairs)
)
covtable1=. cov ctable
cortable1=. cor ctable
    
NB. Explicit definition II
PrimeTest=. 3 : 0
d=. 2
while. d < y.
   do. if. (0: = d&|) y.
       do. r=. 0        
           return.
       else. d=. d+1+d>2
   end.
end.
r=. 1
)

NB. Analysis of variance
x=. 3 4 $ 4 7 5 6 9 4 3 8 2 5 7 3 
T=. 3 : 0
:
+/^:(+/-.x.)(/:x.)|:y.
)
S=. (+/@((*:@,)@T)) % (*/@(-.@[ # $@]))

NB. Permutations and combinations
perm=. i.@! A. i.
PERM=. perm @ # { ]
comb=. |.@ptt # i.@] 
COMB=. ([ comb #@]) { ]

NB. Ranks
w1=. 2.3 5 2.3 3.5 6 2.3 3.5
UNADJranks=. >: @ /:^:2
NUBranks=. (= mp UNADJranks) % [: +/"1 =
ranks=.  [: , |:@= # NUBranks
invranks=. [: ranks -
rcor=. ranks@[ cor ranks@]
French=. 83 27 42 51 53 44 47 55 61 33
German=. 74 22 49 54 48 47 55 61 59 29
ht=. 7.9 6.5 17.8 4.2 13.2
hc=. 5.6 0.4 6.7 1.2 2.9
Wsum=. (#@[ <: i.@#@([,])) +//. ranks @ ([,])
s1=. 42 51 31 61 44 55 48
s2=. 38 53 36 52 33 49 36
Wpsum=. (* +//. ranks@|) @ sort @ ([-])

NB. Runs
runs=. [: >: [: +/  2: (~:/\) ]

NB. Simulation I
die=. >: @ ? @ $&6
dice=. >: @ ? @ (6&($~)@,)
TwoDice=. 2&dice
SumTwoDice=. +/ @ TwoDice
SumTwoDiceFr=. (2&+@i. 11)&rfr@SumTwoDice
EqualTwoDice=. =/ @ TwoDice
NewDice=. (-@[) <\ >: @ ? @ (6&($~)@*)
SumTwoNewDice=. +/"1 @ > @ (2&NewDice)
Coins=. [: +/ [: ? ] $ 2: 
CoinTest=. +/\@(Coins"0 @ $) % ] * (>: @ i. @ [)
   
NB. Central limit theorem 
SumDice=. +/"1 @ > @ NewDice
ExpSum=. 3.5&*
SDSum=. %:@(2.91667&*)
SU=. (] - ExpSum@[) % SDSum@[ 
ISU=. -: @ <. @ +: @ (0.25&+ @ ])
rng=. (-@|., 0: , ])@-:@>:@i. 6
CLTchart=. rng&(;"0) @ (bars@(rng&rfr))
CLTdemo=. CLTchart @ ISU @ ([ SU SumDice)

NB. Simulation II
urand=. (? % ]) @ ($&1e9)
coords=. urand@,&2
incircle=. [: +/ 1: >: +/"1 @ *: @ coords
PIest=. 4: * incircle % ]
stnrand=. 3 : 0
r=. i. 0 2
while. y. > {.$r 
   do. whilst. S >: 1
      do. V=: <:+:urand 2		 
          S=: +/ *: V
   end. 
r=. r, V * %: -+:(^.%])S
end.
)
stnrand1=.  4: %~  _6: + [: +/"1 urand@,&12
exprand=. [ * -@^.@urand@]

NB. De Mere's problems
P=. -. @ (] ^~ -.@[)
P1=. (%6)&P
P2=. (%36)&P

NB. Derivatives and integrals
D=. ("0)(D. 1)
W=. +:(#.|.@])"0 1|:@(0:,%.@(^/~@i)%>:@i=. i.@>:@+:)
ew=. +/@(-@(<:@(#@])*i.@[)|."0 1]{.~>:@([*<:@(#@])))
EW=. ([ ew W@]) f.
ai=. 2 : 0
ai=. +/@(x.&space * x.&[ * y.@(x.&grid))"0
) 
grid=. space *i.@#@[
space=. ] % <:@#@[
I=. (4 EW 5) ai 
snd=. (%:@o.@2:) (%~) ^@-@-:@*:

NB. Probability distributions
cdf=. 1 : 0
+/ @ ([ x.f. (i. @ >: @ ]))
)
G=. !@<:  
B=. (G@[ * G@]) % G@+
binomial=. (x!n) * (p^x) * (-.@p=. {:@[) ^ (n=.{.@[) - x=. ]
BINOMIAL=. binomial cdf
poisson=. ^@-@[ * ^ % !@]
POISSON=. poisson cdf
geometric=. [ * -.@[ ^ ]
GEOMETRIC=. geometric cdf
stnormal=. (%:@o.@2:) (%~) ^@-@-:@*:
STNORMAL=. 3 : 0
stnormal I y.
)
exponential=. [ * ^@(-@[*])
EXPONENTIAL=. 3 : 0
:
x.&exponential I y.
)
tn=. (G@-:@>:@[) % (G@-:@[) * (%:@o.@[)
tnx=. (>: @ (*:@] % [)) ^ (- @ -: @ >: @ [)
tdistn=. tn * tnx
TDISTN=. 3 : 0
:
x.&tdistn I y.
) 
chisq=. ((]^(-:@<:@<:@[))*(^@(-@-:@]))) % ((2: ^ -:@[) * (G@-:@[))
CHISQ=. 3 : 0
:
x.&chisq I y.
)
fmn=. (([^-:@[) * (]^-:@])) % (-:@[) B (-:@])
fmnx=. (] ^ <:@-:@{.@[) * ({:@[ +{.@[ *]) ^ (-@-:@(+/@[))
fdistn=. ({.@[ fmn {:@[) * fmnx 
FDISTN=. 3 : 0
:
x.&fdistn I y.
)
 
NB. Binomial trials
cp=. , @ { @ (] # < @ (-. , ]) @ [)
succ=. +/"1 @ > @ (1&cp)
prob=. */"1 @ > @ cp
bc=. #/.~ @ succ  NB. bc=. i.@>: ! ]
bp=. succ@] +//. prob

NB. Poisson distribution
h=. 0 : 0 
0 2 2 1 0 0 1 1 0 3 0 2 1 0 0 1 0 1 0 1
0 0 0 2 0 3 0 2 0 0 0 1 1 1 0 2 0 3 1 0
0 0 0 2 0 2 0 0 1 1 0 0 2 1 1 0 0 2 0 0
0 0 0 1 1 1 2 0 2 0 0 0 1 0 1 2 1 0 0 0
0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0
0 0 0 0 2 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0
0 0 1 0 2 0 0 1 2 0 1 1 3 1 1 1 0 3 0 0
1 0 1 0 0 0 1 0 1 1 0 0 2 0 0 2 1 0 2 0
1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1
0 0 0 0 0 2 1 1 1 0 2 1 1 0 1 2 0 1 0 0
0 0 1 1 0 1 0 2 0 2 0 0 0 0 2 1 3 0 1 1
0 0 0 0 2 4 0 1 3 0 1 1 1 1 2 1 3 1 3 1
1 1 2 1 1 3 0 4 0 1 0 3 2 1 0 2 1 1 0 0
0 1 0 0 0 0 0 1 0 1 1 0 0 0 2 2 0 0 0 0
)
h=. ".  ,;. _2 h

NB. Locales
mean   =. +/ % #
mean_temp_=. # %: */
test=. <./,mean,>./
test_temp_=. <./,mean,>./

NB. Other software - Utilities
hfu=. '_-'&charsub
ufh=. '-_'&charsub
Jfmt=. (".&>)@chop@toLF
CLIPwrite=. wdclipwrite@hfu@clipfmt
CLIPread=. Jfmt@ufh@wdclipread
DOSwrite=. (hfu@":@[) fwrites ]
DOSread=. Jfmt@ufh@freads

NB. Other software - Statistical packages
AOVlevels=. >:@(] #: i.)@$
Flatten=. (*/@}: , {:)@$  $ ,@]
AOVdata=. , ,. Flatten @ AOVlevels

NB. Coupon collector's problem
pos=. >: @ i.
cc=. * +/ @ % @ pos
int=. ". @ (6.0&":)
cctable=. (] * i. @ [) (int @ cc @ +) table pos @ ]
prize=. >:@?
ccsim=. 3 : 0
r=. 0$0
while. y. > #~.r do.
   r=. r, Prize y.
end.
)
ccsample=. (#@ccsim)"0 @ # 

NB. Appendix 2. Regression 
reg=. 3 : 0
b=. (y=. ;@{: y.)%.X=.(1&,"1)@|:@(>@}:) y.
sst=. +/*:(y-am y)
ssr=. sst-sse=. +/*:(y- X +/ . * b)
F=. (msr=. ssr%k)%mse=. sse%_1+(n=. $y)-k=. <:#y.
rsq=. ssr%sst
seb=. %:(0{mse)*(<1 0)|:%.(|:X)+/ . * X
r=. 49{.'             Var.    Coeff.      S.E.         t'
r=. r, 15.0 12.5 12.5 10.2 ": (i. >:k),. b,. seb,. b%seb
r=. r, ''
r=. r, '  Source     D.F.    S.S.        M.S.         F'
r=. r, 'Regression', 5.0 12.5 12.5 10.2 ": k, ssr,msr,F
r=. r, 'Error     ', 5.0 12.5 12.5": (n-k+1), sse, mse
r=. r, 'Total     ', 5.0 12.5 ": (n-1), sst
r=. r, ''
r=. r, 'S.E. of estimate    ', 10.5":%:mse
r=. r, 'Corr. coeff. squared', 10.5": rsq
)

NB. Appendix 3. Analysis of variance 
T=. 3 : 0
: 
r=. +/^:(+/-.x.)(/:x.)|:y.
)
S=. (+/@((*:@,)@T)) % (*/@(-.@[ # $@]))
allS=. (>@tt@#@$) S"1 _ ]
stt=. <"1@|."1@(/: +/"1)@tt
alphabet=. 'ABCDEF'
tag=. ]#({.&alphabet)@#@]
numtag=. (({.&alphabet)@(#@$@])) e. [
alltags=. (tag &. >)@(1&}.)@stt
expand=. /:@\:@[{#@[{.]
ps=. <"1@expand"1 >@stt@(+/)
ss0=. | @ (-/) @ (>@ps@([numtag]) (+/"1@[ +//. S"1 _) ])
df=. */@<:@(numtag # $@])
term=. ss0 (] , [ , %) df
allterms=. (>@[) term"1 _ ]
AOV=. 3 : 0
(alltags #$y.) AOV y.
:
AOVtable=: x. allterms y.
Labels=. 8{."1 >x.
dfTotal=. <:*/$y.
ssTotal=. (+/*:,y.) - '' ss0 y.
dfError=. dfTotal - +/0{"1 AOVtable
if. dfError>0 do.
   ssError=. ssTotal - +/1{"1 AOVtable
   AOVtable=. AOVtable,ssError(],[,%)dfError
   Labels=. Labels,'Error'
end.
r=. Labels,"1 (5 12.5 12.5)":AOVtable
AOVtable=: AOVtable,TotalRow=. dfTotal,ssTotal
r=. r, 'Total   ',5 12.5":TotalRow
)
Model1=. 'A';'B';'AB';'C';'AC';'BC';'ABC';'D'
TestData=. 25 7 21 4 10 16 5 21 4 25 7 6
TestData=. TestData, 3 6 16 18 20 18 19 17 16 2 15 6
TestData=. TestData, 13 23 8 25 19 19 20 14 23 9 10 18
TestData=. TestData, 27 26 19 24 13 9 19 13 20 18 16 12
TestData=. 2 4 6 $ TestData

NB. Appendix 4. 


NB. ***** END OF SCRIPT FILE *****


 


