This is what the screen looks like when you start running APL*PLUS.  The cursor is indented 6 spaces -- which means that it's your turn to type.  Press Enter to see an example.
4+5
You press the Enter key after typing something to tell APL*PLUS that you're done.  APL*PLUS then evaluates what you've typed and displays the result at the far left margin so you can distinguish your 'input' from APL*PLUS' 'output'.
By the way, any time you want to try APL*PLUS, press the F4 function key, or press F3 to see the APL*PLUS keyboard layout.  To stop the tutorial press Esc.  When you resume the tutorial later it will start at the point you left.  Back to the tutorial...
APL*PLUS is a high-level programming language, but it can also be used as a powerful desk-top calculator.  For example, you can add, subtract, multiply, and divide.
2+3
10-6
350
205
But unlike a calculator APL*PLUS can operate on strings of numbers.
2 + 3 5 7 9 10
9 - 6 4 8 1 3
3  50 45 2 8 9
8  5 2 6 4 10
or string and string...
1 2 3 4 5  50 45 2 8 9
10 20 30 40 50  5 2 6 20 10
To keep the data for further use, we can put it into a variable.
NUMBERS  2 4 7 3 89 34 12
To display the contents of the variable, you simply type its name.
NUMBERS
Then we can apply arithmetic operations to it.
NUMBERS  100
NUMBERS  2.5
Let's take a look at some other arithmetic operations...
Calculate the square root of NUMBERS
NUMBERS * .5
Compute the sum of NUMBERS
+/NUMBERS
Get the maximum and minimum values in NUMBERS
(/NUMBERS),/NUMBERS
Sort NUMBERS in ascending order
 NUMBERS[ NUMBERS]
The same operations can be used with tables of numbers...
First, create two tables of numbers, each with 3 rows and 4 columns
REVENUE  3 4  2 4 6 8 10
EXPENSE  3 4  1 3 5 7 9
Multiply each element of REVENUE by a number
REVENUE  1.10
Divide EXPENSE by REVENUE
REVENUE  EXPENSE
Determine the maximum value in each row
/REVENUE
Sum each row and column of REVENUE
+ / REVENUE
+  REVENUE
Solve a set of simultaneous linear equations, where         x + 2y - 3z = -9              2x -  y + 2z = 16                x +  y -  z = -1
Solve by dividing vector of constants "V" by matrix of coefficients "MX"
V9 16 1
MX  3 3  1 2 3 2 1 2 1 1 1
MX
Solve equations and store X, Y, and Z answers in XYZ
XYZ  V  MX
XYZ
Verify results - multiply MX by answers to get V
MX +. XYZ
Manipulating character data is simple too...
A  'Hello, how are you'
A
What is the length or shape of A?
A
How many times is the letter "o" used in A?
+ / A = 'o'
Append another phrase to A
A  A,' doing today?'
A
Turn A into a matrix with 4 rows and 31 columns
A  4 31  A
A
Display selected columns in row 1 of A
A[1;24 13 2 12 26]
Now let's take a look at combining a few APL expressions into a program.
To define an APL program, you use the APL*PLUS full-screen editor EDIT, which works just like a word processor.  Let's look at a simple program that prints descriptive statistics...
0 0 8 80 wput attr[2]  0 0 8 80 wput 8 80statvr  0 0INKEY
To run the program, you simply type its name, and each line is "executed" as though you just typed it at the keyboard.
STATS 2849 4374 3030 8945 2344 3393 9499 3737 3939
APL*PLUS allows you to define an almost unlimited number of programs in a single workspace that can be "called" by other programs as needed.  So over time you develop a library of utility programs that help you develop applications very quickly.
APL*PLUS comes with hundreds of programs to get you started, and since APL*PLUS can run programs written in other languages, such as C and FORTRAN, you can still use all the programs that you've already written ... but enjoy the productivity benefits of APL*PLUS!
That concludes our brief introduction to APL*PLUS.  To find out about the 100+ APL*PLUS system functions, pick the MORE FEATURES from the upcoming menu.  Also pick the APL PROGRAMS option to see sample APL*PLUS application code.
